/* ============ */
/* setserl.c	*/
/* ============ */
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <miscdefs.h>
#include <serldefs.h>

#define	ACT(X)	#X

#define	CLAMP(Var, Lo, Hi)	__min(Hi, __max(Lo, Var))

#define	NEED_CELL_EXPECT(LO, HI) \
	"Enter Minimum Cell Expectation ["ACT(LO)"-"ACT(HI)"]: "

#define	NEED_DATA_SET_SIZE(LO, HI) \
	"Enter Size of Data Set ["ACT(LO)"-"ACT(HI)"]: "

#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL); printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetSerialControls - Puts Run Controls in SerialData structure	*/
/* ==================================================================== */
void
SetSerialControls(SERIAL_DATA_STRU  *SerialData)
{
    int     NewlineCh;
    int     UserIntEntry;
    long    UserLongEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* ------------------------------------------ */
    /* Request Number Integers in Serial Data Set */
    /* ------------------------------------------ */
    GetInt(NEED_DATA_SET_SIZE(MIN_SET_SIZE, MAX_SET_SIZE), &UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, "Size of Data Set");

    SerialData->SetSize = CLAMP(UserIntEntry, MIN_SET_SIZE, MAX_SET_SIZE);

    SHOW_INT_VALUE_USED(UserIntEntry, SerialData->SetSize);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* ------------------------------ */
    /* Calculate Number of Categories */
    /* ------------------------------ */
    SerialData->NumCategories = SQR(SerialData->SetSize);

    printf("\t%d (Corresponding Number of Categories)\n",
	SerialData->NumCategories);

    /* ------------------------ */
    /* Request Cell Expectation	*/
    /* ------------------------ */
    GetInt(NEED_CELL_EXPECT(MIN_CELL_XPCT, MAX_CELL_XPCT), &UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, "Minimum Cell Expectation");

    /* ---------------------- */
    /* Clamp Cell Expectation */
    /* ---------------------- */
    SerialData->UserCellExpect =
	__min(MAX_CELL_XPCT, __max(MIN_CELL_XPCT, UserIntEntry));

    SHOW_INT_VALUE_USED(UserIntEntry, SerialData->UserCellExpect);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* ------------------------------------------ */
    /* Calculate Minimum Number of Pairs Required */
    /* ------------------------------------------ */
    SerialData->MinNumPairs =
	(long)SerialData->NumCategories *
	(long)SerialData->UserCellExpect;

    /* ------------------------------------------ */
    /* Get Number of Serial Pairs to be Generated */
    /* ------------------------------------------ */
    {
	char	Prompt[64];

	sprintf(Prompt, "How Many Pairs Are To Be Generated?"
			"  [%ld ...]: ", SerialData->MinNumPairs);

	GetLong(Prompt, &UserLongEntry);
    }

    REPORT_USER_INT_ENTRY(UserLongEntry,
	"Number of Serial Pairs To Be Generated");

    SerialData->UserNumPairs =
	__max(UserLongEntry, SerialData->MinNumPairs);

    SHOW_INT_VALUE_USED(UserLongEntry, SerialData->UserNumPairs);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);

    SerialData->CallStatusOK = TRUE;
}
